/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Native;

public final class Platform {
    public static final int UNSPECIFIED = -1;
    public static final int MAC = 0;
    public static final int LINUX = 1;
    public static final int WINDOWS = 2;
    public static final int SOLARIS = 3;
    public static final int FREEBSD = 4;
    public static final int OPENBSD = 5;
    public static final int WINDOWSCE = 6;
    private static final int osType;

    private Platform() {
    }

    public static final int getOSType() {
        return osType;
    }

    public static final boolean isMac() {
        return osType == 0;
    }

    public static final boolean isLinux() {
        return osType == 1;
    }

    public static final boolean isWindowsCE() {
        return osType == 6;
    }

    public static final boolean isWindows() {
        return osType == 2 || osType == 6;
    }

    public static final boolean isSolaris() {
        return osType == 3;
    }

    public static final boolean isFreeBSD() {
        return osType == 4;
    }

    public static final boolean isOpenBSD() {
        return osType == 5;
    }

    public static final boolean isX11() {
        return !Platform.isWindows() && !Platform.isMac();
    }

    public static final boolean deleteNativeLibraryAfterVMExit() {
        return osType == 2;
    }

    public static final boolean hasRuntimeExec() {
        return !Platform.isWindowsCE() || !"J9".equals(System.getProperty("java.vm.name"));
    }

    public static final boolean is64Bit() {
        String model = System.getProperty("sun.arch.data.model");
        if (model != null) {
            return "64".equals(model);
        }
        String arch = System.getProperty("os.arch").toLowerCase();
        if ("x86_64".equals(arch) || "ppc64".equals(arch) || "sparcv9".equals(arch) || "amd64".equals(arch)) {
            return true;
        }
        return Native.POINTER_SIZE == 8;
    }

    public static final boolean isGNU() {
        String name = System.getProperty("os.name").toLowerCase().trim();
        return "gnu".equals(name);
    }

    public static final boolean iskFreeBSD() {
        String name = System.getProperty("os.name").toLowerCase().trim();
        return "gnu/kfreebsd".equals(name);
    }

    public static final String getBaseArch() {
        String arch = System.getProperty("os.arch").toLowerCase().trim();
        if ("amd64".equals(arch)) {
            arch = "x86_64";
        }
        if ("i686-at386".equals(arch)) {
            arch = "i386";
        }
        if ("ppc".equals(arch)) {
            arch = "powerpc";
        }
        if ("ppc64".equals(arch)) {
            arch = "powerpc64";
        }
        return arch;
    }

    public static final boolean isIntel() {
        String arch = System.getProperty("os.arch").toLowerCase().trim();
        return arch.equals("i386") || arch.equals("x86_64") || arch.equals("amd64");
    }

    public static final boolean isPPC() {
        String arch = System.getProperty("os.arch").toLowerCase().trim();
        return arch.equals("ppc") || arch.equals("ppc64");
    }

    public static final boolean isARM() {
        String arch = System.getProperty("os.arch").toLowerCase().trim();
        return arch.equals("arm");
    }

    static {
        String osName = System.getProperty("os.name");
        osType = osName.startsWith("Linux") ? 1 : (osName.startsWith("Mac") || osName.startsWith("Darwin") ? 0 : (osName.startsWith("Windows CE") ? 6 : (osName.startsWith("Windows") ? 2 : (osName.startsWith("Solaris") || osName.startsWith("SunOS") ? 3 : (osName.startsWith("FreeBSD") ? 4 : (osName.startsWith("OpenBSD") ? 5 : -1))))));
    }
}

